#ifndef STUDENTTESTSCORES_H
#define STUDENTTESTSCORES_H
#include <string>
using namespace std;

const double DEFAULT_SCORE = 0.0;

class StudentTestScores
{
private:
  string studentName;  // Imi i nazwisko studenta
  double *testScores;  // Wskanik tablicy z wynikami testw
  int numTestScores;   // Liczba wynikw testw

  // Funkcja prywatna tworzca
  // tablic wynikw testw
  void createTestScoresArray(int size)
  { numTestScores = size;
    testScores = new double[size]; 
    for (int i = 0; i < size; i++)
      testScores[i] = DEFAULT_SCORE; }
        
public:
  // Konstruktor
  StudentTestScores(string name, int numScores)
    { studentName = name;
      createTestScoresArray(numScores); }
     
  // Konstruktor kopiujcy
  StudentTestScores(const StudentTestScores &obj)
    { studentName = obj.studentName;
      numTestScores = obj. numTestScores;
      testScores = new double[numTestScores];
      for (int i = 0; i < numTestScores; i++)
         testScores[i] = obj.testScores[i]; }

  // Destruktor
  ~StudentTestScores()
    { delete [] testScores; }

  // Funkcja setTestScore() zapisujca
  // wynik testu
  void setTestScore(double score, int index)
    { testScores[index] = score; }

  // Funkcja zapisujca imi i nazwisko studenta
  void setStudentName(string name)
    { studentName = name; }

  // Funkcja zwracajca imi i nazwisko studenta
  string getStudentName() const
    { return studentName; }
   
  // Funkcja zwracajca liczb testw
  int getNumTestScores()
    { return numTestScores; }

  // Funkcja zwracajca wynik wskazanego testu
  double getTestScore(int index) const
    { return testScores[index]; }

  // Przeciony operator przypisania
  const StudentTestScores operator=(const StudentTestScores &right)
  { if (this != &right)
    {
      delete[] testScores;
      studentName = right.studentName;
      numTestScores = right.numTestScores;
      testScores = new double[numTestScores];
      for (int i = 0; i < numTestScores; i++)
        testScores[i] = right.testScores[i];
     }
     return *this;
  }
};
#endif